/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.block.BlockNodeProxy;
import com.raoulvdberge.refinedstorage.block.enums.ControllerEnergyType;
import com.raoulvdberge.refinedstorage.block.enums.ControllerType;
import com.raoulvdberge.refinedstorage.block.info.BlockInfoBuilder;
import com.raoulvdberge.refinedstorage.item.itemblock.ItemBlockController;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.meshdefinition.ItemMeshDefinitionController;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelFullbright;
import com.raoulvdberge.refinedstorage.tile.TileController;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockController
extends BlockNodeProxy {
    public static final PropertyEnum<ControllerType> TYPE = PropertyEnum.func_177709_a((String)"type", ControllerType.class);
    public static final PropertyEnum<ControllerEnergyType> ENERGY_TYPE = PropertyEnum.func_177709_a((String)"energy_type", ControllerEnergyType.class);

    public BlockController() {
        super(BlockInfoBuilder.forId("controller").tileEntity(TileController::new).create());
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModelMeshDefinition(this, new ItemMeshDefinitionController());
        modelRegistration.setStateMapper(this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{TYPE}).func_178441_a());
        modelRegistration.addBakedModelOverride(this.info.getId(), base -> new BakedModelFullbright((IBakedModel)base, "refinedstorage:blocks/controller/cutouts/nearly_off", "refinedstorage:blocks/controller/cutouts/nearly_on", "refinedstorage:blocks/controller/cutouts/on"));
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        items.add((Object)ItemBlockController.createStack(new ItemStack((Block)this, 1, 0), 0));
        items.add((Object)ItemBlockController.createStack(new ItemStack((Block)this, 1, 0), RS.INSTANCE.config.controllerCapacity));
        items.add((Object)ItemBlockController.createStack(new ItemStack((Block)this, 1, 1), 0));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().add(new IProperty[]{TYPE}).add(new IProperty[]{ENERGY_TYPE}).build();
    }

    @Override
    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)(meta == 0 ? ControllerType.NORMAL : ControllerType.CREATIVE)));
    }

    @Override
    public int func_176201_c(@Nonnull IBlockState state) {
        return state.func_177229_b(TYPE) == ControllerType.NORMAL ? 0 : 1;
    }

    @Override
    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return super.func_176221_a(state, world, pos).func_177226_a(ENERGY_TYPE, (Comparable)((Object)((TileController)world.func_175625_s(pos)).getEnergyType()));
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.openNetworkGui(0, player, world, pos, side);
    }

    public void func_180633_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull ItemStack stack) {
        if (!world.field_72995_K) {
            TileController controller = (TileController)world.func_175625_s(pos);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && tag.func_74764_b("Energy")) {
                controller.getEnergy().setStored(tag.func_74762_e("Energy"));
            }
        }
        super.func_180633_a(world, pos, state, player, stack);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ItemStack stack = new ItemStack((Block)this, 1, this.func_176201_c(state));
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("Energy", ((TileController)world.func_175625_s(pos)).getEnergy().getStored());
        drops.add((Object)stack);
    }

    @Override
    public Item createItem() {
        return new ItemBlockController(this);
    }
}

